	clear all, clc
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	% Requirements for the digital bandpass filter
	wc1T = 0.2*pi;		wc2T = 0.3*pi;
	ws1T = 0.15*pi;		ws2T = 0.4*pi;
	Amax = -10*log10(1-0.15^2);		Amin = 60;
	
	% Requirements for the analog prototype lowpass filter
	T = 1;
	Wac1 = (2/T)*tan(wc1T/2);	Wac2 = (2/T)*tan(wc2T/2);
	Was1 = (2/T)*tan(ws1T/2);	Was2 = (2/T)*tan(ws2T/2)
	Wac1*Wac2;
	Was1*Was2;
	% We select
	Was2 = Wac1*Wac2/Was1
	% Band edges for the  analog filter
	Omegac = Wac2 - Wac1
	Omegas = Was2 - Was1
	
	% Design of the analog prototype lowpass filter (Cauer)
	N = CA_ORDER_S(Omegac, Omegas, Amax, Amin)
	N = 5;	% We must select an integer order
	
	% Design of the analog prototype lowpass filter (Cauer)
	[Ga, Za, R_ZEROS, Pa, Wsnew] = CA_POLES_S(Omegac, Omegas, Amax, Amin, N);
	
	% Transformation the analog filter into a lowpass digital filter
	[G, Z, P] = PZ_2_PZ_Z(Ga, Za, Pa, T);
	
	wT = linspace(0, pi, 1000);
	%	Att = PZ_2_ATT_Z(G, Z, P, wT);
	%	PLOT_ATTENUATION_Z(wT, Att)
	%	zoom on
	
	% Transformation the lowpass filter into a digital bandpass filter
	[Gbp, Zbp, Pbp] = PZ_2_BP_Z(G, Z, P, wc1T, wc2T, Omegac*T);
	
	figure(1)
	axis_Amax = 80; axis_Tg_max = 80;
	wT = linspace(0, pi, 1000);
	Att = PZ_2_ATT_Z(Gbp, Zbp, Pbp, wT);
	Taug = PZ_2_TG_Z(Gbp, Zbp, Pbp, wT);
	%	PLOT_ATTENUATION_Z(wT, Att)
	PLOT_ATT_TG_Z(Att, Taug, wT, axis_Amax, axis_Tg_max)
	
	zoom on
	figure(2)
	PLOT_PZ_Z(Zbp, Pbp)		
	
	
